package tests;

import centralSystem.CentralSystem;
import centralSystem.ICentralSystem;
import centralSystem.IPostCounter;
import centralSystem.counters.LongestQueueCounter;
import centralSystem.counters.OneServiceCounter;
import centralSystem.counters.PriorityServiceCounter;
import devices.TicketPrinter;
import devices.Visualizer;

public class LongestQueueCounterTest {

	public static void main(String[] args) {

		ICentralSystem sys = new CentralSystem(new TicketPrinter(), new Visualizer());
		IPostCounter pc = new LongestQueueCounter(sys);
		sys.addClientAtQueue(2);
		sys.addClientAtQueue(2);
		sys.addClientAtQueue(2);
		sys.addClientAtQueue(1);
		System.out.println(""+pc.nextService());
		sys.addClientAtQueue(1);
		sys.addClientAtQueue(1);
		System.out.println(""+pc.nextService());
		System.out.println(""+sys.getNextClient(1));
		System.out.println(""+pc.nextService());
		System.out.println(""+pc.nextService());
	}
}
